//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::DoSendData(int xClient)
{
	if( FD_ISSET(Socket[xClient], &WriteFDS) )
	{
		int Result = 0;

		if( SendData[xClient] == NULL)
            return false;

		if( SizeOfSendData[xClient] )
		{
			// DoSendData- Sending...

            Result = WriteLineToClientEx(xClient, SendData[xClient], SizeOfSendData[xClient]);

			FreeClientSend(xClient);

			if(Result == SOCKET_ERROR)
			{
                int LastError = WSAGetLastError();
                if(LastError == WSAEWOULDBLOCK || LastError == WSAEINPROGRESS)
                {
                    return false;
                }

				DisconnectClient(xClient);
				// DoSendData- Socket Error.
				return false;
			}

			if(Result == 0)
			{
				DisconnectClient(xClient);
				// DoSendData- Returned 0.
				return false;
			}

			return true;
		}
	}

	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

